/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspVioEtherConfig;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.lpar.OmLparVscsiUpdater;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50VirtualEthernet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmLparVethUpdater {
    private OmLparMgr mLparMgr;
    private OmCecMgr mCecMgr;
    private RObject mLparObj;
    private RObjectId mLparOid;
    private int updateFlag = 0;
    private FspCmdHelper mCmdHelper;
    private FSPCmdMgr mCmdMgr;

    public OmLparVethUpdater(OmLparMgr omLparMgr) {
        this.mLparMgr = omLparMgr;
        this.mLparObj = this.mLparMgr.getObject();
        this.mLparOid = this.mLparMgr.getObjectId();
        this.mCecMgr = this.mLparMgr.getCecMgr();
        this.mCmdHelper = this.mCecMgr.getCmdHelper();
        this.mCmdMgr = this.mCecMgr.getCmdMgr();
    }

    public void update(Hashtable hashtable) throws RException, PIHscServerException, PIHscCmdMgrException {
        Object object;
        UnsignedInt16[] unsignedInt16Array;
        UnsignedInt16 unsignedInt16;
        UnsignedInt16 unsignedInt162;
        Object object2;
        Object object3;
        Object object4;
        RObject rObject;
        Object object5;
        Object object6;
        Enumeration<Object> enumeration;
        Vector vector = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualEthernet);
        if (vector != null) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object6 = (RObject)enumeration.nextElement();
                object5 = (String)((RObject)object6).getProperty("Name");
                rObject = new UnsignedInt16((String)object5);
                object4 = (VioSlotState)hashtable.get(rObject);
                if (object4 == null) {
                    this.deleteVeth((RObject)object6);
                    continue;
                }
                object3 = this.mCmdHelper.getVirtualEthernetSlotConfiguration(new UnsignedInt16(this.mLparMgr.getLparIndex()), (UnsignedInt16)rObject);
                if (this.updateVethInstance((RObject)object6, (FspVioEtherConfig)object3, (VioSlotState)object4)) {
                    // empty if block
                }
                object2 = ((FspVioEtherConfig)object3).getIsIEEE();
                unsignedInt162 = ((FspVioEtherConfig)object3).getPortVid();
                unsignedInt16 = ((FspVioEtherConfig)object3).getAdditionalVids();
                unsignedInt16Array = new HashSet();
                unsignedInt16Array.add(unsignedInt162);
                if (object2.intValue() == 1) {
                    for (int i = 0; i < ((UnsignedInt16[])unsignedInt16).length; ++i) {
                        unsignedInt16Array.add(unsignedInt16[i]);
                    }
                }
                object = ((FspVioEtherConfig)object3).getIsTrunk();
                boolean bl = false;
                if (object != null) {
                    bl = object.shortValue() != 0;
                }
                this.updateVethVlans((HashSet)unsignedInt16Array, (RObject)object6, bl);
                hashtable.remove(rObject);
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object6 = (VioSlotState)enumeration.nextElement();
            object5 = ((VioSlotState)object6).slotNumber;
            rObject = OmLparVscsiUpdater.getSameSlotNum(object5, this.mLparMgr.getLparName());
            if (rObject != null) {
                OmLparVscsiUpdater.deleteVslotWithDiffType(rObject, this.mLparMgr);
                continue;
            }
            object4 = new RObjectId(1, R50Define.CID_IBMHSC_VirtualEthernet);
            ((RObjectId)object4).setKeyValue(0, "IBMHSC_VirtualEthernet");
            ((RObjectId)object4).setKeyValue(1, ((VioSlotState)object6).slotNumber.toString());
            ((RObjectId)object4).setKeyValue(2, "IBMHSC_Partition");
            ((RObjectId)object4).setKeyValue(3, this.mLparMgr.getLparName());
            object3 = new RObject((RObjectId)object4);
            ((RObject)object3).addInstance();
            ((RObject)object3).addAssociation(R50Define.AID_IBMHSC_LparVirtualEthernet, this.mLparOid);
            object2 = this.mCmdHelper.getVirtualEthernetSlotConfiguration(new UnsignedInt16(this.mLparMgr.getLparIndex()), ((VioSlotState)object6).slotNumber);
            this.updateVethInstance((RObject)object3, (FspVioEtherConfig)object2, (VioSlotState)object6);
            unsignedInt162 = ((FspVioEtherConfig)object2).getIsIEEE();
            unsignedInt16 = ((FspVioEtherConfig)object2).getPortVid();
            unsignedInt16Array = ((FspVioEtherConfig)object2).getAdditionalVids();
            object = new HashSet();
            ((HashSet)object).add(unsignedInt16);
            if (unsignedInt162.intValue() == 1) {
                for (int i = 0; i < unsignedInt16Array.length; ++i) {
                    ((HashSet)object).add(unsignedInt16Array[i]);
                }
            }
            UnsignedInt8 unsignedInt8 = ((FspVioEtherConfig)object2).getIsTrunk();
            boolean bl = false;
            if (unsignedInt8 != null) {
                bl = unsignedInt8.shortValue() != 0;
            }
            this.updateVethVlans((HashSet)object, (RObject)object3, bl);
        }
    }

    private boolean updateVethInstance(RObject rObject, FspVioEtherConfig fspVioEtherConfig, VioSlotState vioSlotState) throws RException {
        boolean bl = false;
        UnsignedInt8 unsignedInt8 = fspVioEtherConfig.getIsIEEE();
        UnsignedInt16 unsignedInt16 = fspVioEtherConfig.getPortVid();
        Boolean bl2 = new Boolean(fspVioEtherConfig.isRequired());
        String string = fspVioEtherConfig.getMACAddress();
        if (rObject.setProperty(R50VirtualEthernet.Index_PVlanID, (Object)unsignedInt16)) {
            bl = true;
        }
        if (rObject.setProperty(R50VirtualEthernet.Index_IsIEEE, (Object)unsignedInt8)) {
            bl = true;
        }
        if (rObject.setProperty(R50VirtualEthernet.Index_Required, (Object)bl2)) {
            bl = true;
        }
        if (rObject.setProperty(R50VirtualEthernet.Index_MACAddress, (Object)string)) {
            bl = true;
        }
        if (rObject.setProperty(R50VirtualEthernet.Index_DrcIndex, (Object)fspVioEtherConfig.getDrcIndex())) {
            bl = true;
        }
        if (rObject.setProperty(R50VirtualEthernet.Index_DrcName, (Object)fspVioEtherConfig.getDrcName())) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerClass", (Object)vioSlotState.curLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerId", (Object)vioSlotState.currentSlotLockOwner)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerClass", (Object)vioSlotState.pendLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerId", (Object)vioSlotState.pendingSlotLockOwner)) {
            bl = true;
        }
        return bl;
    }

    private void updateVethVlans(HashSet hashSet, RObject rObject, boolean bl) throws RException {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        RObject rObject2 = this.mCecMgr.getObject();
        Vector vector = rObject2.associators(R50Define.AID_IBMHSC_CompSysVLAN);
        Hashtable hashtable = new Hashtable();
        if (vector != null) {
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                iterator = (RObject)object4.nextElement();
                object3 = (String)((RObject)((Object)iterator)).getProperty("Name");
                object2 = new UnsignedInt16((String)object3);
                hashtable.put((UnsignedInt16)object2, iterator);
            }
        }
        if (!bl) {
            rObject.deleteAssociations(R50Define.AID_IBMHSC_VLANTrunk);
        }
        if ((object4 = rObject.associators(R50Define.AID_IBMHSC_VLANFor)) != null) {
            iterator = ((Vector)object4).elements();
            while (iterator.hasMoreElements()) {
                object3 = (RObject)iterator.nextElement();
                object2 = ((RObject)object3).getObjectId();
                object = (String)((RObject)object3).getProperty("Name");
                UnsignedInt16 unsignedInt16 = new UnsignedInt16((String)object);
                if (!hashSet.contains(unsignedInt16)) {
                    Vector vector2;
                    rObject.deleteAssociation(R50Define.AID_IBMHSC_VLANFor, (RObjectId)object2);
                    try {
                        rObject.deleteAssociation(R50Define.AID_IBMHSC_VLANTrunk, (RObjectId)object2);
                    }
                    catch (RException rException) {
                        // empty catch block
                    }
                    if ((vector2 = ((RObject)object3).associators(R50Define.AID_IBMHSC_VLANFor)) != null && vector2.size() != 0) continue;
                    ((RObject)object3).deleteInstance();
                    hashtable.remove(unsignedInt16);
                    continue;
                }
                hashSet.remove(unsignedInt16);
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object3 = (UnsignedInt16)iterator.next();
            object2 = (RObject)hashtable.get(object3);
            if (object2 == null) {
                object2 = this.createVlan((UnsignedInt16)object3);
            }
            object = ((RObject)object2).getObjectId();
            rObject.addAssociation(R50Define.AID_IBMHSC_VLANFor, (RObjectId)object);
            if (!bl) continue;
            rObject.addAssociation(R50Define.AID_IBMHSC_VLANTrunk, (RObjectId)object);
        }
    }

    public void deleteVeth(RObject rObject) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_VLANFor);
        rObject.deleteInstance();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RObject rObject2 = (RObject)enumeration.nextElement();
                Vector vector2 = rObject2.associators(R50Define.AID_IBMHSC_VLANFor);
                if (vector2 != null && vector2.size() != 0) continue;
                rObject2.deleteInstance();
            }
        }
    }

    private RObject createVlan(UnsignedInt16 unsignedInt16) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VLAN);
        rObjectId.setKeyValue(0, "IBMHSC_VLAN");
        rObjectId.setKeyValue(1, unsignedInt16.toString());
        rObjectId.setKeyValue(2, "IBMHSC_ComputerSystem");
        rObjectId.setKeyValue(3, this.mCecMgr.getCecName());
        RObject rObject = new RObject(rObjectId);
        rObject.addInstance();
        RObject rObject2 = this.mCecMgr.getObject();
        rObject2.addAssociation(R50Define.AID_IBMHSC_CompSysVLAN, rObjectId);
        return rObject;
    }
}

